<?php
session_start();
include 'conexao.php';

// Locale para mês em português
setlocale(LC_TIME, 'pt_PT.UTF-8', 'pt_PT', 'pt_BR.UTF-8', 'portuguese');

$ano = $_GET['ano'] ?? date('Y');

$total_receita = 0;
$total_despesa = 0;
$saldo_geral = 0;
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatório Anual</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #007bff;
            --secondary-color: #6c757d;
            --success-color: #28a745;
            --danger-color: #dc3545;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--light-color);
            color: var(--dark-color);
            margin: 0;
            padding: 20px;
        }

        .container {
            max-width: 900px;
            margin: 0 auto;
            background-color: #fff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .institutional-header {
            text-align: center;
            margin-bottom: 20px;
            font-size: 14px;
            line-height: 1.2;
        }
        .institutional-header img {
            width: 80px;
            margin-bottom: 10px;
        }
        .institutional-header h3, .institutional-header p {
            margin: 0;
        }
        .institutional-header h3 {
            font-weight: 600;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h2 {
            font-size: 24px;
            color: var(--primary-color);
            margin: 0;
        }

        .form-container {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
            margin-bottom: 20px;
        }
        .form-container label {
            font-weight: 600;
        }
        .form-container input, .form-container button {
            padding: 8px 12px;
            border-radius: 6px;
            border: 1px solid #ccc;
            font-family: inherit;
        }
        .form-container button {
            background-color: var(--primary-color);
            color: #fff;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        .form-container button:hover {
            background-color: #0056b3;
        }

        .print-btn-container {
            text-align: right;
            margin-bottom: 20px;
        }
        .print-btn {
            padding: 10px 20px;
            font-size: 16px;
            background-color: var(--success-color);
            color: #fff;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        .print-btn:hover {
            background-color: #218838;
        }

        .table-container {
            width: 100%;
            overflow-x: auto;
        }
        table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            overflow: hidden;
            min-width: 600px;
        }
        th, td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }
        th {
            background-color: var(--dark-color);
            color: #fff;
            font-weight: 600;
        }
        tbody tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .total-row {
            font-weight: bold;
            background-color: #e9ecef !important;
            color: var(--dark-color);
        }
        .total-row td {
            border-top: 2px solid var(--dark-color);
        }

        @media print {
            body { background-color: #fff; padding: 0; }
            .container { box-shadow: none; border-radius: 0; padding: 0; border: none; }
            .form-container, .print-btn-container { display: none; }
            table { border-color: #000; }
            th, td { border-color: #000; }
            .total-row {
                background-color: #e9ecef !important;
                -webkit-print-color-adjust: exact;
                color-adjust: exact;
            }
            .institutional-header {
                display: block !important;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="institutional-header">
        <img src="insignia/insignia.png" alt="Insígnia" />
        <h3>REPÚBLICA DE ANGOLA</h3>
        <p>Governo Provincial de Benguela</p>
        <p>Gabinete Provincial da Educação</p>
        <h3>COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA</h3>
    </div>

    <div class="header">
        <h2>RELATÓRIO FINANCEIRO ANUAL - <?= $ano ?></h2>
    </div>

    <div class="form-container">
        <form method="GET">
            <label>Ano: <input type="number" name="ano" value="<?= $ano ?>"></label>
            <button type="submit">Ver Relatório</button>
        </form>
    </div>

    <div class="print-btn-container">
        <button class="print-btn" onclick="window.print()">🖨️ Imprimir</button>
    </div>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Mês</th>
                    <th>Total Receitas (KZ)</th>
                    <th>Total Despesas (KZ)</th>
                    <th>Saldo (KZ)</th>
                </tr>
            </thead>
            <tbody>
                <?php
                for ($mes = 1; $mes <= 12; $mes++):
                    $receitas = $conn->query("SELECT SUM(valor) AS total FROM movimentos_diarios WHERE tipo = 'Entrada' AND MONTH(data) = $mes AND YEAR(data) = '$ano'");
                    $despesas = $conn->query("SELECT SUM(valor) AS total FROM movimentos_diarios WHERE tipo = 'Saída' AND MONTH(data) = $mes AND YEAR(data) = '$ano'");

                    $valor_r = $receitas->fetch_assoc()['total'] ?? 0;
                    $valor_d = $despesas->fetch_assoc()['total'] ?? 0;
                    $saldo = $valor_r - $valor_d;

                    $total_receita += $valor_r;
                    $total_despesa += $valor_d;
                ?>
                <tr>
                    <td><?= ucfirst(strftime('%B', mktime(0, 0, 0, $mes, 10))) ?></td>
                    <td><?= number_format($valor_r, 2, ',', '.') ?></td>
                    <td><?= number_format($valor_d, 2, ',', '.') ?></td>
                    <td><?= number_format($saldo, 2, ',', '.') ?></td>
                </tr>
                <?php endfor; ?>
            </tbody>
            <tfoot>
                <tr class="total-row">
                    <td>Total Anual</td>
                    <td><?= number_format($total_receita, 2, ',', '.') ?></td>
                    <td><?= number_format($total_despesa, 2, ',', '.') ?></td>
                    <td><?= number_format($total_receita - $total_despesa, 2, ',', '.') ?></td>
                </tr>
            </tfoot>
        </table>
    </div>

</div>

</body>
</html>